#include<bits/stdc++.h>
#include "solve_dlazaw.hpp"

using namespace std;
using namespace Solve;


int n, m, max_oper, max_sum;
vector<int> V;
int oper, sum;

function<void(int, string)>  end_prog = {};

int get_cmp(int x, int y){
	return (V[x] > V[y]);
}
void get_rev(int x, int y){
	reverse(V.begin() + x, V.begin() + y + 1);
}
bool done(){
	return is_sorted(V.begin(), V.end());
}

char cmp(int x, int y){
	if(min(x, y) < 1 || max(x, y) > n + m)
		end_prog(0, "Porównanie wywołano na parze indeksów (" + to_string(x) + ", "
			+ to_string(y) + "), która nie jest poprawna (n = " + to_string(n) + ", m = " + to_string(m) + ")");
	if(x == y)
		end_prog(0, "Porównanie elementu z samym sobą");
	return "<>"[get_cmp(x - 1, y - 1)];
}

void rev(int x, int y){
	if(min(x, y) < 1 || max(x, y) > n + m || x > y)
		end_prog(0, "Odwrócenie wykonane na przedziale [" + to_string(x) + ", "
			+ to_string(y) + "], który nie jest poprawny (n = " + to_string(n) + ", m = " + to_string(m) + ")");
	get_rev(x - 1, y - 1);
	sum += y - x;
}


int main(int argc, char** argv) {
    auto& I = Interactor::create(argc, argv);
	
	end_prog = [&] (int score, const std::string& msg) {
        I.end(score, msg);
    };
	
	auto& input = I.test_reader();
    input >> n >> m >> max_oper >> max_sum;
	V.resize(n + m);
	for(int i = 0; i < n + m; i++){
		input >> V[i];
	}

	I.writer(0) << n << " " << m  << " " << max_oper << " " << max_sum << endl;

	while(true){
       	char c;
        I.reader(0) >> c;
		if(c != '!')oper++;
		if(oper > max_oper){
        	end_prog(0, "Przekroczono limit " + to_string(max_oper) + " operacji");
		}
		if(c == '?'){
			int x, y;
			I.reader(0) >> x >> y;
			cerr << "----> ? " << x << " " << y << "\n";
			char d = cmp(x, y);
			I.writer(0) << d << endl;
			cerr << d << endl;
        }
        else if(c == '^'){
			int x, y;
			I.reader(0) >> x >> y;
			cerr << "----> ^ " <<  x  << " " << y << endl;
			rev(x, y);
			if(sum > max_sum){
        		end_prog(0, "Przekroczono limit " + to_string(max_sum) + " sumy długości");
			}
		}
        else if(c == '!'){
			cerr << "----> !" << endl;
			if(done()){
				end_prog(100, "OK, liczba operacji: " + to_string(oper) + ", suma długości: " + to_string(sum));
			}
			else{
				end_prog(0, "Ciąg nie został posortowany");
			}
        }
        else{
        	end_prog(0, "Oczekiwano ?, ^ lub !, otrzymano " + c);
        }
    }

	return 0;
}